//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3
import QtQuick.Controls.Styles 1.1

import wesual.Controls 1.0

ScrollViewStyle {
    id : style

    readonly property int scrollBarSize : 17 // + invisible ScrollViewFrame 1 px
    readonly property int scrollHandleSize : 12 + 3
    // effective handle size is 12 + 3 margin for centering

    scrollToClickedPosition : true

    scrollBarBackground : Rectangle {
        color : UI.color(UI.PrimaryBase)

        Component.onCompleted : {
            if (styleData.horizontal) {
                height = scrollBarSize;
            } else {
                width = scrollBarSize;
            }
        }
    }
    decrementControl : Item {}
    incrementControl : Item {}
    corner : Item {}
    frame : Rectangle {
        color : UI.color(UI.PrimaryBase)
    }

    handle : Item {
        width : scrollHandleSize
        height : scrollHandleSize
        onWidthChanged : {
            if (styleData.horizontal || width === scrollHandleSize)
                return;
            width = scrollHandleSize;
        }
        onHeightChanged : {
            if (!styleData.horizontal || height == scrollHandleSize)
                return;
            height = scrollHandleSize;
        }

        Rectangle {
            border {
                width : 1
                color : UI.color(UI.ScrollViewBorder)
            }
            color : UI.color(UI.ScrollView)
            anchors.fill : parent
            anchors.leftMargin : !styleData.horizontal ? 3 : 0
            anchors.topMargin : styleData.horizontal ? 3 : 0
        }

        MouseArea {
            anchors.fill : parent
            preventStealing : true
            onClicked : { mouse.accepted = true;}
        }
    }
}
